<%@ page language="java" contentType="text/html; charset=UTF-8"
		 pageEncoding="UTF-8"%>
<!DOCTYPE html>
<html lang="zh">
<head>
	<meta charset="utf-8">
	<meta name="viewport" content="width=device-width, initial-scale=1, maximum-scale=1, user-scalable=no" />
	<title>首页 - 光年(角色列表)OA管理系统</title>
	<link rel="icon" href="favicon.ico" type="image/ico">
	<meta name="keywords" content="ukoko.cn">
	<meta name="description" content="解决中小企业...">
	<meta name="author" content="夜泊">
	<link href="css/bootstrap.min.css" rel="stylesheet">
	<link href="css/materialdesignicons.min.css" rel="stylesheet">
	<link href="css/style.min.css" rel="stylesheet">
</head>

<body>
<div class="lyear-layout-web">
	<div class="lyear-layout-container">
		<!--左侧导航-->
		<aside class="lyear-layout-sidebar">

			<!-- logo -->
			<div id="logo" class="sidebar-header">
				<a href="index.html"><img src="images/logo-sidebar.png" title="LightYear" alt="LightYear" /></a>
			</div>
			<div class="lyear-layout-sidebar-scroll">

				<!-- 左侧菜单栏位置 -->
				<jsp:include page="menu.jsp"></jsp:include>

			</div>

		</aside>
		<!--End 左侧导航-->

		<!--头部信息-->
		<header class="lyear-layout-header">

			<nav class="navbar navbar-default">
				<div class="topbar">

					<div class="topbar-left">
						<div class="lyear-aside-toggler">
							<span class="lyear-toggler-bar"></span>
							<span class="lyear-toggler-bar"></span>
							<span class="lyear-toggler-bar"></span>
						</div>
						<span class="navbar-page-title"> 后台首页 </span>
					</div>

				</div>
			</nav>

		</header>
		<!--End 头部信息-->

		<!--页面主要内容-->
		<main class="lyear-layout-content">

			<div class="container-fluid">
				<!-- 内容区 -->
				<div class="row">
					<div class="col-lg-12">
						<div class="card">
							<div class="table-responsive">
								<table class="table">
									<thead>
									<tr>
										<th>序号</th>
										<th>角色名称</th>
										<th>有/无效</th>
										<th colspan="2" class="text-center">操作</th>
									</tr>
									</thead>
									<tbody id="tbody">

									</tbody>
								</table>
							</div>
						</div>
					</div>

				</div>
				<!-- 内容区结束 -->
				<div class="row">
					<div class="col-lg-4 text-left">
						<a class="btn btn-info" href="${pageContext.request.contextPath }/RoleToAddServlet">添加角色</a>
					</div>
					<div class="col-lg-4 text-center">
						<nav>
							<ul class="pagination" id="pageId">

							</ul>
						</nav>
					</div>
					<div class="col-lg-4 text-center">
						<a class="btn btn-info" href="RoleExcelDownServlet">导出Excel</a>
					</div>
				</div>
			</div>

		</main>
		<!--End 页面主要内容-->
	</div>
</div>

<script type="text/javascript" src="js/jquery.min.js"></script>
<script type="text/javascript" src="js/bootstrap.min.js"></script>
<script type="text/javascript" src="js/perfect-scrollbar.min.js"></script>
<script type="text/javascript" src="js/main.min.js"></script>


<script type="text/javascript">

	var pageNo=1;//当前页
	var pageSize=2;//页容量
	var pageCount=0;//总页数

	//首页数据获取
	$.getJSON("RoleJsonListServlet",{pageNo:pageNo,pageSize:pageSize},function(d){
		console.log("--->>>",d);

		//初始化pageCount
		pageCount=d.pageCount;
		pageNo=d.pageNo;

		//将当前页数据设置到DOM对象中
		var list = d.obj;
		var str="";
		for(var i=0;i<list.length;i++){
			str+="<tr>\r\n" +
					"							<th>"+list[i].roleId+"</th>\r\n" +
					"							<td>"+list[i].roleName+"</td>\r\n" +
					"							<td>"+list[i].status+"</td>\r\n" +
					"							<td class=\"text-right\">\r\n" +
					"								<a onclick=\"if(confirm('是否删除')){return true;}else{return false;}\" class=\"btn btn-w-xs btn-round btn-info\" href=\"${pageContext.request.contextPath}/RoleDeleteServlet?roleId="+list[i].roleId+"\">删除</a>\r\n" +
					"							</td>\r\n" +
					"							<td class=\"text-left\">\r\n" +
					"								<a class=\"btn btn-w-xs btn-round btn-info\" href=\"${pageContext.request.contextPath}/RoleToUpdateServlet?roleId="+list[i].roleId+"\">更新</a>\r\n" +
					"							</td>\r\n" +
					"						  </tr>";
		}
		//console.log(str);
		//拼接好的字符串设置到tbody节点中
		$("#tbody").html(str);

		joinPage(pageNo,pageCount);
		cssPage(pageNo,"pc");
		bindEvent(pageNo,pageCount);
	});


	/* 绑定事件函数 */
	function bindEvent(pageNo,pageCount){
		/* 中间页事件绑定 */
		var pcs = $(".pc");
		for(var i=0;i<pcs.length;i++){
			$(pcs[i]).click(function(){
				//console.log(this);
				//获取当前DOM对象的文本节点
				var pText = this.innerHTML;
				//console.log(parseInt(pText));
				pageNo=parseInt(pText);

				$.getJSON("RoleJsonListServlet",{pageNo:pageNo,pageSize:pageSize},function(d){
					console.log("--->>>",d);

					//初始化pageCount
					pageCount=d.pageCount;
					pageNo=d.pageNo;

					//将当前页数据设置到DOM对象中
					var list = d.obj;

					var str="";

					for(var i=0;i<list.length;i++){
						str+="<tr>\r\n" +
								"							<th>"+list[i].roleId+"</th>\r\n" +
								"							<td>"+list[i].roleName+"</td>\r\n" +
								"							<td>"+list[i].status+"</td>\r\n" +
								"							<td class=\"text-right\">\r\n" +
								"								<a onclick=\"if(confirm('是否删除')){return true;}else{return false;}\" class=\"btn btn-w-xs btn-round btn-info\" href=\"#\">删除</a>\r\n" +
								"							</td>\r\n" +
								"							<td class=\"text-left\">\r\n" +
								"								<a class=\"btn btn-w-xs btn-round btn-info\" href=\"${pageContext.request.contextPath}/RoleToUpdateServlet?roleId="+list[i].roleId+"\">更新</a>\r\n" +
								"							</td>\r\n" +
								"						  </tr>";
					}
					//console.log(str);
					//拼接好的字符串设置到tbody节点中
					$("#tbody").html(str);

					joinPage(pageNo,pageCount);
					cssPage(pageNo,"pc");
					bindEvent(pageNo,pageCount);
				});
			});
		}


		/* 绑定下一页事件 */
		$("#nextId").click(function(){

			if(pageNo>=pageCount){
				alert("已经是最后一页");
			}else{
				pageNo=pageNo+1;

				$.getJSON("RoleJsonListServlet",{pageNo:pageNo,pageSize:pageSize},function(d){
					console.log("--->>>",d);

					//初始化pageCount
					pageCount=d.pageCount;
					pageNo=d.pageNo;

					//将当前页数据设置到DOM对象中
					var list = d.obj;

					var str="";

					for(var i=0;i<list.length;i++){
						str+="<tr>\r\n" +
								"							<th>"+list[i].roleId+"</th>\r\n" +
								"							<td>"+list[i].roleName+"</td>\r\n" +
								"							<td>"+list[i].status+"</td>\r\n" +
								"							<td class=\"text-right\">\r\n" +
								"								<a onclick=\"if(confirm('是否删除')){return true;}else{return false;}\" class=\"btn btn-w-xs btn-round btn-info\" href=\"#\">删除</a>\r\n" +
								"							</td>\r\n" +
								"							<td class=\"text-left\">\r\n" +
								"								<a class=\"btn btn-w-xs btn-round btn-info\" href=\"${pageContext.request.contextPath}/RoleToUpdateServlet?roleId="+list[i].roleId+"\">更新</a>\r\n" +
								"							</td>\r\n" +
								"						  </tr>";
					}
					//console.log(str);
					//拼接好的字符串设置到tbody节点中
					$("#tbody").html(str);

					joinPage(pageNo,pageCount);
					cssPage(pageNo,"pc");
					bindEvent(pageNo,pageCount);
				});
			}

		});

		//给上一页绑定事件
		$("#preId").click(function(){

			if(pageNo<=1){
				alert("已经是第一页");
			}else{
				pageNo=pageNo-1;

				$.getJSON("RoleJsonListServlet",{pageNo:pageNo,pageSize:pageSize},function(d){
					console.log("--->>>",d);

					//初始化pageCount
					pageCount=d.pageCount;
					pageNo=d.pageNo;

					//将当前页数据设置到DOM对象中
					var list = d.obj;

					var str="";

					for(var i=0;i<list.length;i++){
						str+="<tr>\r\n" +
								"							<th>"+list[i].roleId+"</th>\r\n" +
								"							<td>"+list[i].roleName+"</td>\r\n" +
								"							<td>"+list[i].status+"</td>\r\n" +
								"							<td class=\"text-right\">\r\n" +
								"								<a onclick=\"if(confirm('是否删除')){return true;}else{return false;}\" class=\"btn btn-w-xs btn-round btn-info\" href=\"#\">删除</a>\r\n" +
								"							</td>\r\n" +
								"							<td class=\"text-left\">\r\n" +
								"								<a class=\"btn btn-w-xs btn-round btn-info\" href=\"${pageContext.request.contextPath}/RoleToUpdateServlet?roleId="+list[i].roleId+"\">更新</a>\r\n" +
								"							</td>\r\n" +
								"						  </tr>";
					}
					//console.log(str);
					//拼接好的字符串设置到tbody节点中
					$("#tbody").html(str);

					joinPage(pageNo,pageCount);
					cssPage(pageNo,"pc");
					bindEvent(pageNo,pageCount);
				});
			}

		});


	}


	/* 生成分页标签的函数 */
	function joinPage(pageNo,pageCount){
		var str="<li id='preId'><a href=\"#!\"><span><i class=\"mdi mdi-chevron-left\"></i></span></a></li>";
		//判断总页数是否大于3
		if(pageCount<=3){
			for(var i=1;i<=pageCount;i++){
				str+="<li><a class='pc' href=\"#!\">"+i+"</a></li>";
			}
		}else{
			//总页数如果大于3
			if(pageNo<=3){
				for(var i=1;i<=3;i++){
					str+="<li><a class='pc' href=\"#!\">"+i+"</a></li>";
				}
			}else{
				for(var i=pageNo-1;i<=pageNo;i++){
					str+="<li><a class='pc' href=\"#!\">"+i+"</a></li>";
				}
			}
		}
		str+="<li id='nextId'><a href=\"#!\"><span><i class=\"mdi mdi-chevron-right\"></i></span></a></li>";

		//设置到指定的DOM元素中
		$("#pageId").html(str);
	}

	/* 当前页样式设置 */
	function cssPage(pageNo,css){
		var pcs = $("."+css);
		for(var i=0;i<pcs.length;i++){
			var pc =  pcs[i]; //DOM
			if(pc.innerHTML==pageNo){ //如果相等说明当前pc为当前页的dom
				var ppc = $(pc).parent(); //li
				ppc.addClass("active"); //为指定的元素添加类名
			}
		}
	}

</script>


</body>
</html>