<%@ page language="java" contentType="text/html; charset=UTF-8"
    pageEncoding="UTF-8"%>
<!DOCTYPE html>
<html lang="zh">
<head>
<meta charset="utf-8">
<meta name="viewport" content="width=device-width, initial-scale=1, maximum-scale=1, user-scalable=no" />
<title>首页 - 光年(首页)OA管理系统</title>
<link rel="icon" href="favicon.ico" type="image/ico">
<meta name="keywords" content="ukoko.cn">
<meta name="description" content="解决中小企业...">
<meta name="author" content="夜泊">
<link href="css/bootstrap.min.css" rel="stylesheet">
<link href="css/materialdesignicons.min.css" rel="stylesheet">
<link href="css/style.min.css" rel="stylesheet">
</head>
  
<body>
<%
  String empName = (String) session.getAttribute("empName");
  if(empName == null || empName == ""){
    response.sendRedirect("login.jsp");
  }
%>

<div class="lyear-layout-web">
  <div class="lyear-layout-container">
    <!--左侧导航-->
    <aside class="lyear-layout-sidebar">
      
      <!-- logo -->
      <div id="logo" class="sidebar-header">
        <a href="index.html"><img src="images/logo-sidebar.png" title="LightYear" alt="LightYear" /></a>
      </div>
      <div class="lyear-layout-sidebar-scroll"> 
        
        <!-- 左侧菜单栏位置 -->
      	<jsp:include page="menu.jsp"></jsp:include>
      
      
      </div>
      
    </aside>
    <!--End 左侧导航-->
    
    <!--头部信息-->
    <header class="lyear-layout-header">
      
      <nav class="navbar navbar-default">
        <div class="topbar">
          
          <div class="topbar-left">
            <div class="lyear-aside-toggler">
              <span class="lyear-toggler-bar"></span>
              <span class="lyear-toggler-bar"></span>
              <span class="lyear-toggler-bar"></span>
            </div>
            <span class="navbar-page-title"> 后台首页 </span>
          </div>
          
          <jsp:include page="user.jsp"></jsp:include>
          
        </div>
      </nav>
      
    </header>
    <!--End 头部信息-->
    
    <!--页面主要内容-->
    <main class="lyear-layout-content">
      <div class="container-fluid">
        <div class="row">
          <div class="col-sm-6 col-lg-3">
            <div class="card bg-primary">
              <div class="card-body clearfix">
                <div class="pull-right">
                  <p class="h6 text-white m-t-0">总收入</p>
                  <p class="h3 text-white m-b-0">102,125.00</p>
                </div>
                <div class="pull-left"> <span class="img-avatar img-avatar-48 bg-translucent"><i class="mdi mdi-currency-cny fa-1-5x"></i></span> </div>
              </div>
            </div>
          </div>
          
          <div class="col-sm-6 col-lg-3">
            <div class="card bg-danger">
              <div class="card-body clearfix">
                <div class="pull-right">
                  <p class="h6 text-white m-t-0">当月收入</p>
                  <p class="h3 text-white m-b-0">920,000</p>
                </div>
                <div class="pull-left"> <span class="img-avatar img-avatar-48 bg-translucent"><i class="mdi mdi-account fa-1-5x"></i></span> </div>
              </div>
            </div>
          </div>
          
          <div class="col-sm-6 col-lg-3">
            <div class="card bg-success">
              <div class="card-body clearfix">
                <div class="pull-right">
                  <p class="h6 text-white m-t-0">总新增学员</p>
                  <p class="h3 text-white m-b-0">3400</p>
                </div>
                <div class="pull-left"> <span class="img-avatar img-avatar-48 bg-translucent"><i class="mdi mdi-arrow-down-bold fa-1-5x"></i></span> </div>
              </div>
            </div>
          </div>
          
          <div class="col-sm-6 col-lg-3">
            <div class="card bg-purple">
              <div class="card-body clearfix">
                <div class="pull-right">
                  <p class="h6 text-white m-t-0">当月新增学员</p>
                  <p class="h3 text-white m-b-0">153</p>
                </div>
                <div class="pull-left"> <span class="img-avatar img-avatar-48 bg-translucent"><i class="mdi mdi-comment-outline fa-1-5x"></i></span> </div>
              </div>
            </div>
          </div>
        </div>
        
        <div class="row">
          
          <div class="col-lg-6"> 
            <div class="card">
              <div class="card-header">
                <h4>月新增人数</h4>
              </div>
              <div class="card-body">
                <!-- 柱状图位置 -->
                <div id="container" style="min-width: 310px; height: 300px; margin: 0 auto"></div>
              </div>
            </div>
          </div>
          
          <div class="col-lg-6"> 
            <div class="card">
              <div class="card-header">
                <h4>全年交易金额</h4>
              </div>
              <div class="card-body">
                <!-- 折线图位置 -->
                <div id="container1" style="max-width:800px;height:300px"></div>
              </div>
            </div>
          </div>
           
        </div>
        
        <div class="row">
          
          <div class="col-lg-12">
            <div class="card">
              <div class="card-header">
                <h4>任务信息</h4>
              </div>
              <div class="card-body">
                <div class="table-responsive">
                  <table class="table table-hover">
                    <thead>
                      <tr>
                        <th>#</th>
                        <th>任务名称</th>
                        <th>开始日期</th>
                        <th>状态</th>
                        <th>操作</th>
                      </tr>
                    </thead>
                    <tbody>
                      <tr>
                        <td>1</td>
                        <td>设计新主题</td>
                        <td>10/02/2019</td>
                        <td><span class="label label-warning">待定</span></td>
                        <td>
                          <div class="progress progress-striped progress-sm">
                            <div class="progress-bar progress-bar-warning" style="width: 45%;"></div>
                          </div>
                        </td>
                      </tr>
                      <tr>
                        <td>1</td>
                        <td>设计新主题</td>
                        <td>10/02/2019</td>
                        <td><span class="label label-warning">待定</span></td>
                        <td>
                          <div class="progress progress-striped progress-sm">
                            <div class="progress-bar progress-bar-warning" style="width: 45%;"></div>
                          </div>
                        </td>
                      </tr>
					  <tr>
					    <td>1</td>
					    <td>设计新主题</td>
					    <td>10/02/2019</td>
					    <td><span class="label label-warning">待定</span></td>
					    <td>
					      <div class="progress progress-striped progress-sm">
					        <div class="progress-bar progress-bar-warning" style="width: 45%;"></div>
					      </div>
					    </td>
					  </tr>
                    </tbody>
                  </table>
                </div>
              </div>
            </div>
          </div>
          
        </div>
        
      </div>
      
    </main>
    <!--End 页面主要内容-->
  </div>
</div>

<script type="text/javascript" src="js/jquery.min.js"></script>
<script type="text/javascript" src="js/bootstrap.min.js"></script>
<script type="text/javascript" src="js/perfect-scrollbar.min.js"></script>
<script type="text/javascript" src="js/main.min.js"></script>

<script type="text/javascript" src="${pageContext.request.contextPath }/js/highcharts.js"></script>
<script type="text/javascript">

	/* 通过AJAX获取前端图表数据  异步 */
	
	$.getJSON("ChartServlet",function(d){
		/* 生成表格 */
		Highcharts.chart('container', {
		    chart: {
		        type: 'column'
		    },
		    title: {
		        text: ''
		    },
		    subtitle: {
		        text: ''
		    },
		    xAxis: {
		        type: 'category'
		    },
		    yAxis: {
		        title: {
		            text: '总人数'
		        }
		    },
		    legend: {
		        enabled: false
		    },
		    plotOptions: {
		        series: {
		            borderWidth: 0,
		            dataLabels: {
		                enabled: true
		            }
		        }
		    },
		    tooltip: {
		        enabled:false
		    },
		    series: [{
		        data: d.list
		    }]
		});
		
		
		
		
		
		Highcharts.chart('container1', {
			title: {
					text: ''
			},
			subtitle: {
					text: ''
			},
			yAxis: {
					title: {
							text: '资金(￥)'
					}
			},
			legend: {
					layout: 'vertical',
					align: 'right',
					verticalAlign: 'middle'
			},
			plotOptions: {
					series: {
							label: {
									connectorAllowed: false
							},
							pointStart: 2010
					}
			},
			series: d.list2,
			responsive: {
					rules: [{
							condition: {
									maxWidth: 500
							},
							chartOptions: {
									legend: {
											layout: 'horizontal',
											align: 'center',
											verticalAlign: 'bottom'
									}
							}
					}]
			}
		});
		
		
	});
	






</script>
</body>
</html>