/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.druid.sql.dialect.sqlserver.parser;

import com.alibaba.druid.sql.ast.SQLExpr;
import com.alibaba.druid.sql.ast.SQLName;
import com.alibaba.druid.sql.ast.expr.SQLIntegerExpr;
import com.alibaba.druid.sql.ast.expr.SQLNullExpr;
import com.alibaba.druid.sql.ast.expr.SQLPropertyExpr;
import com.alibaba.druid.sql.ast.statement.SQLColumnDefinition;
import com.alibaba.druid.sql.dialect.sqlserver.ast.SQLServerColumnDefinition;
import com.alibaba.druid.sql.dialect.sqlserver.ast.SQLServerTop;
import com.alibaba.druid.sql.dialect.sqlserver.ast.expr.SQLServerObjectReferenceExpr;
import com.alibaba.druid.sql.dialect.sqlserver.parser.SQLServerLexer;
import com.alibaba.druid.sql.dialect.sqlserver.parser.SQLServerSelectParser;
import com.alibaba.druid.sql.parser.Lexer;
import com.alibaba.druid.sql.parser.SQLExprParser;
import com.alibaba.druid.sql.parser.Token;

public class SQLServerExprParser
extends SQLExprParser {
    public static final String[] AGGREGATE_FUNCTIONS = new String[]{"AVG", "COUNT", "MAX", "MIN", "ROW_NUMBER", "STDDEV", "SUM"};

    public SQLServerExprParser(Lexer lexer) {
        super(lexer);
        this.aggregateFunctions = AGGREGATE_FUNCTIONS;
    }

    public SQLServerExprParser(String sql) {
        this(new SQLServerLexer(sql));
        this.lexer.nextToken();
    }

    @Override
    public SQLExpr primary() {
        if (this.lexer.token() == Token.LBRACKET) {
            this.lexer.nextToken();
            SQLName name = this.name();
            this.accept(Token.RBRACKET);
            return this.primaryRest(name);
        }
        return super.primary();
    }

    @Override
    public SQLServerSelectParser createSelectParser() {
        return new SQLServerSelectParser(this);
    }

    @Override
    public SQLExpr primaryRest(SQLExpr expr) {
        if (this.lexer.token() == Token.DOTDOT) {
            expr = this.nameRest((SQLName)expr);
        }
        return super.primaryRest(expr);
    }

    @Override
    protected SQLExpr dotRest(SQLExpr expr) {
        boolean backet = false;
        if (this.lexer.token() == Token.LBRACKET) {
            this.lexer.nextToken();
            backet = true;
        }
        expr = super.dotRest(expr);
        if (backet) {
            this.accept(Token.RBRACKET);
        }
        return expr;
    }

    @Override
    public SQLName nameRest(SQLName expr) {
        if (this.lexer.token() == Token.DOTDOT) {
            this.lexer.nextToken();
            boolean backet = false;
            if (this.lexer.token() == Token.LBRACKET) {
                this.lexer.nextToken();
                backet = true;
            }
            String text = this.lexer.stringVal();
            this.lexer.nextToken();
            if (backet) {
                this.accept(Token.RBRACKET);
            }
            SQLServerObjectReferenceExpr owner = new SQLServerObjectReferenceExpr(expr);
            expr = new SQLPropertyExpr(owner, text);
        }
        return super.nameRest(expr);
    }

    public SQLServerTop parseTop() {
        if (this.lexer.token() == Token.TOP) {
            SQLServerTop top = new SQLServerTop();
            this.lexer.nextToken();
            boolean paren = false;
            if (this.lexer.token() == Token.LPAREN) {
                paren = true;
                this.lexer.nextToken();
            }
            top.setExpr(this.primary());
            if (paren) {
                this.accept(Token.RPAREN);
            }
            if (this.lexer.token() == Token.PERCENT) {
                this.lexer.nextToken();
                top.setPercent(true);
            }
            return top;
        }
        return null;
    }

    @Override
    protected SQLColumnDefinition createColumnDefinition() {
        SQLServerColumnDefinition column = new SQLServerColumnDefinition();
        return column;
    }

    @Override
    public SQLColumnDefinition parseColumnRest(SQLColumnDefinition column) {
        if (this.lexer.token() == Token.IDENTITY) {
            this.lexer.nextToken();
            this.accept(Token.LPAREN);
            SQLIntegerExpr seed = (SQLIntegerExpr)this.primary();
            this.accept(Token.COMMA);
            SQLIntegerExpr increment = (SQLIntegerExpr)this.primary();
            this.accept(Token.RPAREN);
            SQLServerColumnDefinition.Identity identity = new SQLServerColumnDefinition.Identity();
            identity.setSeed((Integer)seed.getNumber());
            identity.setIncrement((Integer)increment.getNumber());
            if (this.lexer.token() == Token.NOT) {
                this.lexer.nextToken();
                if (this.lexer.token() == Token.NULL) {
                    this.lexer.nextToken();
                    column.setDefaultExpr(new SQLNullExpr());
                } else {
                    this.accept(Token.FOR);
                    this.identifierEquals("REPLICATION ");
                    identity.setNotForReplication(true);
                }
            }
            SQLServerColumnDefinition sqlSreverColumn = (SQLServerColumnDefinition)column;
            sqlSreverColumn.setIdentity(identity);
        }
        return super.parseColumnRest(column);
    }
}

