/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.druid.sql.ast.statement;

import com.alibaba.druid.sql.ast.SQLExpr;
import com.alibaba.druid.sql.ast.SQLObjectImpl;
import com.alibaba.druid.sql.ast.SQLReplaceable;
import com.alibaba.druid.sql.visitor.SQLASTVisitor;

public class SQLAssignItem
extends SQLObjectImpl
implements SQLReplaceable {
    private SQLExpr target;
    private SQLExpr value;

    public SQLAssignItem() {
    }

    public SQLAssignItem(SQLExpr target, SQLExpr value) {
        this.setTarget(target);
        this.setValue(value);
    }

    @Override
    public SQLAssignItem clone() {
        SQLAssignItem x = new SQLAssignItem();
        if (this.target != null) {
            x.setTarget(this.target.clone());
        }
        if (this.value != null) {
            x.setValue(this.value.clone());
        }
        return x;
    }

    public SQLExpr getTarget() {
        return this.target;
    }

    public void setTarget(SQLExpr target) {
        if (target != null) {
            target.setParent(this);
        }
        this.target = target;
    }

    public SQLExpr getValue() {
        return this.value;
    }

    public void setValue(SQLExpr value) {
        if (value != null) {
            value.setParent(this);
        }
        this.value = value;
    }

    @Override
    public void output(StringBuffer buf) {
        this.target.output(buf);
        buf.append(" = ");
        this.value.output(buf);
    }

    @Override
    protected void accept0(SQLASTVisitor visitor) {
        if (visitor.visit(this)) {
            this.acceptChild(visitor, this.target);
            this.acceptChild(visitor, this.value);
        }
        visitor.endVisit(this);
    }

    @Override
    public boolean replace(SQLExpr expr, SQLExpr target) {
        if (this.target == expr) {
            this.setTarget(target);
            return true;
        }
        if (this.value == expr) {
            this.setValue(target);
            return true;
        }
        return false;
    }
}

