/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.druid.wall;

import com.alibaba.druid.sql.SQLUtils;
import com.alibaba.druid.sql.ast.SQLName;
import com.alibaba.druid.sql.ast.SQLStatement;
import com.alibaba.druid.sql.ast.statement.SQLUpdateStatement;
import com.alibaba.druid.sql.dialect.mysql.ast.statement.MySqlHintStatement;
import com.alibaba.druid.sql.parser.Lexer;
import com.alibaba.druid.sql.parser.NotAllowCommentException;
import com.alibaba.druid.sql.parser.ParserException;
import com.alibaba.druid.sql.parser.SQLStatementParser;
import com.alibaba.druid.sql.parser.Token;
import com.alibaba.druid.sql.visitor.ExportParameterVisitor;
import com.alibaba.druid.sql.visitor.ParameterizedOutputVisitorUtils;
import com.alibaba.druid.util.JdbcSqlStatUtils;
import com.alibaba.druid.util.LRUCache;
import com.alibaba.druid.util.Utils;
import com.alibaba.druid.wall.Violation;
import com.alibaba.druid.wall.WallCheckResult;
import com.alibaba.druid.wall.WallConfig;
import com.alibaba.druid.wall.WallContext;
import com.alibaba.druid.wall.WallDenyStat;
import com.alibaba.druid.wall.WallFunctionStat;
import com.alibaba.druid.wall.WallFunctionStatValue;
import com.alibaba.druid.wall.WallProviderStatValue;
import com.alibaba.druid.wall.WallSqlFunctionStat;
import com.alibaba.druid.wall.WallSqlStat;
import com.alibaba.druid.wall.WallSqlStatValue;
import com.alibaba.druid.wall.WallSqlTableStat;
import com.alibaba.druid.wall.WallTableStat;
import com.alibaba.druid.wall.WallTableStatValue;
import com.alibaba.druid.wall.WallUpdateCheckHandler;
import com.alibaba.druid.wall.WallVisitor;
import com.alibaba.druid.wall.spi.WallVisitorUtils;
import com.alibaba.druid.wall.violation.IllegalSQLObjectViolation;
import com.alibaba.druid.wall.violation.SyntaxErrorViolation;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public abstract class WallProvider {
    private String name;
    private final Map<String, Object> attributes = new ConcurrentHashMap<String, Object>(1, 0.75f, 1);
    private boolean whiteListEnable = true;
    private LRUCache<String, WallSqlStat> whiteList;
    private int MAX_SQL_LENGTH = 8192;
    private int whiteSqlMaxSize = 1000;
    private boolean blackListEnable = true;
    private LRUCache<String, WallSqlStat> blackList;
    private LRUCache<String, WallSqlStat> blackMergedList;
    private int blackSqlMaxSize = 200;
    protected final WallConfig config;
    private final ReentrantReadWriteLock lock = new ReentrantReadWriteLock();
    private static final ThreadLocal<Boolean> privileged = new ThreadLocal();
    private final ConcurrentMap<String, WallFunctionStat> functionStats = new ConcurrentHashMap<String, WallFunctionStat>(16, 0.75f, 1);
    private final ConcurrentMap<String, WallTableStat> tableStats = new ConcurrentHashMap<String, WallTableStat>(16, 0.75f, 1);
    public final WallDenyStat commentDeniedStat = new WallDenyStat();
    protected String dbType = null;
    protected final AtomicLong checkCount = new AtomicLong();
    protected final AtomicLong hardCheckCount = new AtomicLong();
    protected final AtomicLong whiteListHitCount = new AtomicLong();
    protected final AtomicLong blackListHitCount = new AtomicLong();
    protected final AtomicLong syntaxErrorCount = new AtomicLong();
    protected final AtomicLong violationCount = new AtomicLong();
    protected final AtomicLong violationEffectRowCount = new AtomicLong();
    private static final ThreadLocal<Object> tenantValueLocal = new ThreadLocal();

    public WallProvider(WallConfig config) {
        this.config = config;
    }

    public WallProvider(WallConfig config, String dbType) {
        this.config = config;
        this.dbType = dbType;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Map<String, Object> getAttributes() {
        return this.attributes;
    }

    public void reset() {
        this.checkCount.set(0L);
        this.hardCheckCount.set(0L);
        this.violationCount.set(0L);
        this.whiteListHitCount.set(0L);
        this.blackListHitCount.set(0L);
        this.clearWhiteList();
        this.clearBlackList();
        this.functionStats.clear();
        this.tableStats.clear();
    }

    public ConcurrentMap<String, WallTableStat> getTableStats() {
        return this.tableStats;
    }

    public ConcurrentMap<String, WallFunctionStat> getFunctionStats() {
        return this.functionStats;
    }

    public WallSqlStat getSqlStat(String sql) {
        WallSqlStat sqlStat = this.getWhiteSql(sql);
        if (sqlStat == null) {
            sqlStat = this.getBlackSql(sql);
        }
        return sqlStat;
    }

    public WallTableStat getTableStat(String tableName) {
        String lowerCaseName = tableName.toLowerCase();
        if (lowerCaseName.startsWith("`") && lowerCaseName.endsWith("`")) {
            lowerCaseName = lowerCaseName.substring(1, lowerCaseName.length() - 1);
        }
        return this.getTableStatWithLowerName(lowerCaseName);
    }

    public void addUpdateCount(WallSqlStat sqlStat, long updateCount) {
        sqlStat.addUpdateCount(updateCount);
        Map<String, WallSqlTableStat> sqlTableStats = sqlStat.getTableStats();
        if (sqlTableStats == null) {
            return;
        }
        for (Map.Entry<String, WallSqlTableStat> entry : sqlTableStats.entrySet()) {
            String tableName = entry.getKey();
            WallTableStat tableStat = this.getTableStat(tableName);
            if (tableStat == null) continue;
            WallSqlTableStat sqlTableStat = entry.getValue();
            if (sqlTableStat.getDeleteCount() > 0) {
                tableStat.addDeleteDataCount(updateCount);
                continue;
            }
            if (sqlTableStat.getUpdateCount() > 0) {
                tableStat.addUpdateDataCount(updateCount);
                continue;
            }
            if (sqlTableStat.getInsertCount() <= 0) continue;
            tableStat.addInsertDataCount(updateCount);
        }
    }

    public void addFetchRowCount(WallSqlStat sqlStat, long fetchRowCount) {
        sqlStat.addAndFetchRowCount(fetchRowCount);
        Map<String, WallSqlTableStat> sqlTableStats = sqlStat.getTableStats();
        if (sqlTableStats == null) {
            return;
        }
        for (Map.Entry<String, WallSqlTableStat> entry : sqlTableStats.entrySet()) {
            WallSqlTableStat sqlTableStat;
            String tableName = entry.getKey();
            WallTableStat tableStat = this.getTableStat(tableName);
            if (tableStat == null || (sqlTableStat = entry.getValue()).getSelectCount() <= 0) continue;
            tableStat.addFetchRowCount(fetchRowCount);
        }
    }

    public WallTableStat getTableStatWithLowerName(String lowerCaseName) {
        WallTableStat stat = (WallTableStat)this.tableStats.get(lowerCaseName);
        if (stat == null) {
            if (this.tableStats.size() > 10000) {
                return null;
            }
            this.tableStats.putIfAbsent(lowerCaseName, new WallTableStat());
            stat = (WallTableStat)this.tableStats.get(lowerCaseName);
        }
        return stat;
    }

    public WallFunctionStat getFunctionStat(String functionName) {
        String lowerCaseName = functionName.toLowerCase();
        return this.getFunctionStatWithLowerName(lowerCaseName);
    }

    public WallFunctionStat getFunctionStatWithLowerName(String lowerCaseName) {
        WallFunctionStat stat = (WallFunctionStat)this.functionStats.get(lowerCaseName);
        if (stat == null) {
            if (this.functionStats.size() > 10000) {
                return null;
            }
            this.functionStats.putIfAbsent(lowerCaseName, new WallFunctionStat());
            stat = (WallFunctionStat)this.functionStats.get(lowerCaseName);
        }
        return stat;
    }

    public WallConfig getConfig() {
        return this.config;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public WallSqlStat addWhiteSql(String sql, Map<String, WallSqlTableStat> tableStats, Map<String, WallSqlFunctionStat> functionStats, boolean syntaxError) {
        String mergedSql;
        if (!this.whiteListEnable) {
            WallSqlStat stat = new WallSqlStat(tableStats, functionStats, syntaxError);
            return stat;
        }
        try {
            mergedSql = ParameterizedOutputVisitorUtils.parameterize(sql, this.dbType);
        }
        catch (Exception ex) {
            WallSqlStat stat = new WallSqlStat(tableStats, functionStats, syntaxError);
            stat.incrementAndGetExecuteCount();
            return stat;
        }
        if (mergedSql != sql) {
            WallSqlStat mergedStat;
            this.lock.readLock().lock();
            try {
                if (this.whiteList == null) {
                    this.whiteList = new LRUCache(this.whiteSqlMaxSize);
                }
                mergedStat = (WallSqlStat)this.whiteList.get(mergedSql);
            }
            finally {
                this.lock.readLock().unlock();
            }
            if (mergedStat == null) {
                WallSqlStat newStat = new WallSqlStat(tableStats, functionStats, syntaxError);
                newStat.setSample(sql);
                this.lock.writeLock().lock();
                try {
                    mergedStat = (WallSqlStat)this.whiteList.get(mergedSql);
                    if (mergedStat == null) {
                        this.whiteList.put(mergedSql, newStat);
                        mergedStat = newStat;
                    }
                }
                finally {
                    this.lock.writeLock().unlock();
                }
            }
            mergedStat.incrementAndGetExecuteCount();
            return mergedStat;
        }
        this.lock.writeLock().lock();
        try {
            WallSqlStat wallStat;
            if (this.whiteList == null) {
                this.whiteList = new LRUCache(this.whiteSqlMaxSize);
            }
            if ((wallStat = (WallSqlStat)this.whiteList.get(sql)) == null) {
                wallStat = new WallSqlStat(tableStats, functionStats, syntaxError);
                this.whiteList.put(sql, wallStat);
                wallStat.setSample(sql);
                wallStat.incrementAndGetExecuteCount();
            }
            WallSqlStat wallSqlStat = wallStat;
            return wallSqlStat;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public WallSqlStat addBlackSql(String sql, Map<String, WallSqlTableStat> tableStats, Map<String, WallSqlFunctionStat> functionStats, List<Violation> violations, boolean syntaxError) {
        String mergedSql;
        if (!this.blackListEnable) {
            return new WallSqlStat(tableStats, functionStats, violations, syntaxError);
        }
        try {
            mergedSql = ParameterizedOutputVisitorUtils.parameterize(sql, this.dbType);
        }
        catch (Exception ex) {
            mergedSql = sql;
        }
        this.lock.writeLock().lock();
        try {
            WallSqlStat wallStat;
            if (this.blackList == null) {
                this.blackList = new LRUCache(this.blackSqlMaxSize);
            }
            if (this.blackMergedList == null) {
                this.blackMergedList = new LRUCache(this.blackSqlMaxSize);
            }
            if ((wallStat = (WallSqlStat)this.blackList.get(sql)) == null) {
                wallStat = (WallSqlStat)this.blackMergedList.get(mergedSql);
                if (wallStat == null) {
                    wallStat = new WallSqlStat(tableStats, functionStats, violations, syntaxError);
                    this.blackMergedList.put(mergedSql, wallStat);
                    wallStat.setSample(sql);
                }
                wallStat.incrementAndGetExecuteCount();
                this.blackList.put(sql, wallStat);
            }
            WallSqlStat wallSqlStat = wallStat;
            return wallSqlStat;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    public Set<String> getWhiteList() {
        HashSet hashSet = new HashSet();
        this.lock.readLock().lock();
        try {
            if (this.whiteList != null) {
                hashSet.addAll(this.whiteList.keySet());
            }
        }
        finally {
            this.lock.readLock().unlock();
        }
        return Collections.unmodifiableSet(hashSet);
    }

    public Set<String> getSqlList() {
        HashSet hashSet = new HashSet();
        this.lock.readLock().lock();
        try {
            if (this.whiteList != null) {
                hashSet.addAll(this.whiteList.keySet());
            }
            if (this.blackMergedList != null) {
                hashSet.addAll(this.blackMergedList.keySet());
            }
        }
        finally {
            this.lock.readLock().unlock();
        }
        return Collections.unmodifiableSet(hashSet);
    }

    public Set<String> getBlackList() {
        HashSet hashSet = new HashSet();
        this.lock.readLock().lock();
        try {
            if (this.blackList != null) {
                hashSet.addAll(this.blackList.keySet());
            }
        }
        finally {
            this.lock.readLock().unlock();
        }
        return Collections.unmodifiableSet(hashSet);
    }

    public void clearCache() {
        this.lock.writeLock().lock();
        try {
            if (this.whiteList != null) {
                this.whiteList = null;
            }
            if (this.blackList != null) {
                this.blackList = null;
            }
            if (this.blackMergedList != null) {
                this.blackMergedList = null;
            }
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    public void clearWhiteList() {
        this.lock.writeLock().lock();
        try {
            if (this.whiteList != null) {
                this.whiteList = null;
            }
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    public void clearBlackList() {
        this.lock.writeLock().lock();
        try {
            if (this.blackList != null) {
                this.blackList = null;
            }
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public WallSqlStat getWhiteSql(String sql) {
        String mergedSql;
        WallSqlStat stat = null;
        this.lock.readLock().lock();
        try {
            if (this.whiteList == null) {
                WallSqlStat wallSqlStat = null;
                return wallSqlStat;
            }
            stat = (WallSqlStat)this.whiteList.get(sql);
        }
        finally {
            this.lock.readLock().unlock();
        }
        if (stat != null) {
            return stat;
        }
        try {
            mergedSql = ParameterizedOutputVisitorUtils.parameterize(sql, this.dbType, (List<Object>)null);
        }
        catch (Exception ex) {
            return null;
        }
        this.lock.readLock().lock();
        try {
            stat = (WallSqlStat)this.whiteList.get(mergedSql);
        }
        finally {
            this.lock.readLock().unlock();
        }
        return stat;
    }

    public WallSqlStat getBlackSql(String sql) {
        this.lock.readLock().lock();
        try {
            if (this.blackList == null) {
                WallSqlStat wallSqlStat = null;
                return wallSqlStat;
            }
            WallSqlStat wallSqlStat = (WallSqlStat)this.blackList.get(sql);
            return wallSqlStat;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public boolean whiteContains(String sql) {
        return this.getWhiteSql(sql) != null;
    }

    public abstract SQLStatementParser createParser(String var1);

    public abstract WallVisitor createWallVisitor();

    public abstract ExportParameterVisitor createExportParameterVisitor();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean checkValid(String sql) {
        WallContext originalContext = WallContext.current();
        try {
            WallContext.create(this.dbType);
            WallCheckResult result = this.checkInternal(sql);
            boolean bl = result.getViolations().isEmpty();
            return bl;
        }
        finally {
            if (originalContext == null) {
                WallContext.clearContext();
            }
        }
    }

    public void incrementCommentDeniedCount() {
        this.commentDeniedStat.incrementAndGetDenyCount();
    }

    public boolean checkDenyFunction(String functionName) {
        if (functionName == null) {
            return true;
        }
        functionName = functionName.toLowerCase();
        return !this.getConfig().getDenyFunctions().contains(functionName);
    }

    public boolean checkDenySchema(String schemaName) {
        if (schemaName == null) {
            return true;
        }
        if (!this.config.isSchemaCheck()) {
            return true;
        }
        schemaName = schemaName.toLowerCase();
        return !this.getConfig().getDenySchemas().contains(schemaName);
    }

    public boolean checkDenyTable(String tableName) {
        if (tableName == null) {
            return true;
        }
        tableName = WallVisitorUtils.form(tableName);
        return !this.getConfig().getDenyTables().contains(tableName);
    }

    public boolean checkReadOnlyTable(String tableName) {
        if (tableName == null) {
            return true;
        }
        tableName = WallVisitorUtils.form(tableName);
        return !this.getConfig().isReadOnly(tableName);
    }

    public WallDenyStat getCommentDenyStat() {
        return this.commentDeniedStat;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public WallCheckResult check(String sql) {
        WallContext originalContext = WallContext.current();
        try {
            WallContext.createIfNotExists(this.dbType);
            WallCheckResult wallCheckResult = this.checkInternal(sql);
            return wallCheckResult;
        }
        finally {
            if (originalContext == null) {
                WallContext.clearContext();
            }
        }
    }

    private WallCheckResult checkInternal(String sql) {
        WallCheckResult result;
        boolean endOfComment;
        boolean syntaxError;
        ArrayList<SQLStatement> statementList;
        ArrayList<Violation> violations;
        WallContext context;
        block26: {
            WallCheckResult checkResult;
            boolean mulltiTenant;
            this.checkCount.incrementAndGet();
            context = WallContext.current();
            if (this.config.isDoPrivilegedAllow() && WallProvider.ispPrivileged()) {
                WallCheckResult checkResult2 = new WallCheckResult();
                checkResult2.setSql(sql);
                return checkResult2;
            }
            boolean bl = mulltiTenant = this.config.getTenantTablePattern() != null && this.config.getTenantTablePattern().length() > 0;
            if (!mulltiTenant && (checkResult = this.checkWhiteAndBlackList(sql)) != null) {
                checkResult.setSql(sql);
                return checkResult;
            }
            this.hardCheckCount.incrementAndGet();
            violations = new ArrayList<Violation>();
            statementList = new ArrayList<SQLStatement>();
            syntaxError = false;
            endOfComment = false;
            try {
                SQLStatementParser parser = this.createParser(sql);
                parser.getLexer().setCommentHandler(WallCommentHandler.instance);
                if (!this.config.isCommentAllow()) {
                    parser.getLexer().setAllowComment(false);
                }
                if (!this.config.isCompleteInsertValuesCheck()) {
                    parser.setParseCompleteValues(false);
                    parser.setParseValuesSize(this.config.getInsertValuesCheckSize());
                }
                parser.parseStatementList(statementList);
                Token lastToken = parser.getLexer().token();
                if (lastToken != Token.EOF && this.config.isStrictSyntaxCheck()) {
                    violations.add(new IllegalSQLObjectViolation(1001, "not terminal sql, token " + (Object)((Object)lastToken), sql));
                }
                endOfComment = parser.getLexer().isEndOfComment();
            }
            catch (NotAllowCommentException e) {
                violations.add(new IllegalSQLObjectViolation(1104, "comment not allow", sql));
                this.incrementCommentDeniedCount();
            }
            catch (ParserException e) {
                this.syntaxErrorCount.incrementAndGet();
                syntaxError = true;
                if (this.config.isStrictSyntaxCheck()) {
                    violations.add(new SyntaxErrorViolation(e, sql));
                }
            }
            catch (Exception e) {
                if (!this.config.isStrictSyntaxCheck()) break block26;
                violations.add(new SyntaxErrorViolation(e, sql));
            }
        }
        if (statementList.size() > 1 && !this.config.isMultiStatementAllow()) {
            violations.add(new IllegalSQLObjectViolation(2201, "multi-statement not allow", sql));
        }
        WallVisitor visitor = this.createWallVisitor();
        visitor.setSqlEndOfComment(endOfComment);
        if (statementList.size() > 0) {
            boolean lastIsHint = false;
            for (int i = 0; i < statementList.size(); ++i) {
                SQLStatement stmt = (SQLStatement)statementList.get(i);
                if ((i == 0 || lastIsHint) && stmt instanceof MySqlHintStatement) {
                    lastIsHint = true;
                    continue;
                }
                try {
                    stmt.accept(visitor);
                    continue;
                }
                catch (ParserException e) {
                    violations.add(new SyntaxErrorViolation(e, sql));
                }
            }
        }
        if (visitor.getViolations().size() > 0) {
            violations.addAll(visitor.getViolations());
        }
        Map<String, WallSqlTableStat> tableStat = context.getTableStats();
        boolean updateCheckHandlerEnable = false;
        WallUpdateCheckHandler updateCheckHandler = this.config.getUpdateCheckHandler();
        if (updateCheckHandler != null) {
            for (SQLStatement stmt : statementList) {
                String tableName;
                Set<String> updateCheckColumns;
                SQLUpdateStatement updateStmt;
                SQLName table;
                if (!(stmt instanceof SQLUpdateStatement) || (table = (updateStmt = (SQLUpdateStatement)stmt).getTableName()) == null || (updateCheckColumns = this.config.getUpdateCheckTable(tableName = table.getSimpleName())) == null || updateCheckColumns.size() <= 0) continue;
                updateCheckHandlerEnable = true;
                break;
            }
        }
        WallSqlStat sqlStat = null;
        if (violations.size() > 0) {
            this.violationCount.incrementAndGet();
            if (!updateCheckHandlerEnable && sql.length() < this.MAX_SQL_LENGTH) {
                sqlStat = this.addBlackSql(sql, tableStat, context.getFunctionStats(), violations, syntaxError);
            }
        } else if (!updateCheckHandlerEnable && sql.length() < this.MAX_SQL_LENGTH) {
            sqlStat = this.addWhiteSql(sql, tableStat, context.getFunctionStats(), syntaxError);
        }
        Map<String, WallSqlTableStat> tableStats = null;
        Map<String, WallSqlFunctionStat> functionStats = null;
        if (context != null) {
            tableStats = context.getTableStats();
            functionStats = context.getFunctionStats();
            this.recordStats(tableStats, functionStats);
        }
        if (sqlStat != null) {
            context.setSqlStat(sqlStat);
            result = new WallCheckResult(sqlStat, statementList);
        } else {
            result = new WallCheckResult(null, violations, tableStats, functionStats, statementList, syntaxError);
        }
        String resultSql = visitor.isSqlModified() ? SQLUtils.toSQLString(statementList, this.dbType) : sql;
        result.setSql(resultSql);
        result.setUpdateCheckItems(visitor.getUpdateCheckItems());
        return result;
    }

    private WallCheckResult checkWhiteAndBlackList(String sql) {
        WallSqlStat sqlStat;
        if (this.config.getUpdateCheckHandler() != null) {
            return null;
        }
        if (this.blackListEnable && (sqlStat = this.getBlackSql(sql)) != null) {
            this.blackListHitCount.incrementAndGet();
            this.violationCount.incrementAndGet();
            if (sqlStat.isSyntaxError()) {
                this.syntaxErrorCount.incrementAndGet();
            }
            sqlStat.incrementAndGetExecuteCount();
            this.recordStats(sqlStat.getTableStats(), sqlStat.getFunctionStats());
            return new WallCheckResult(sqlStat);
        }
        if (this.whiteListEnable && (sqlStat = this.getWhiteSql(sql)) != null) {
            this.whiteListHitCount.incrementAndGet();
            sqlStat.incrementAndGetExecuteCount();
            if (sqlStat.isSyntaxError()) {
                this.syntaxErrorCount.incrementAndGet();
            }
            this.recordStats(sqlStat.getTableStats(), sqlStat.getFunctionStats());
            WallContext context = WallContext.current();
            if (context != null) {
                context.setSqlStat(sqlStat);
            }
            return new WallCheckResult(sqlStat);
        }
        return null;
    }

    void recordStats(Map<String, WallSqlTableStat> tableStats, Map<String, WallSqlFunctionStat> functionStats) {
        Object sqlTableStat;
        String tableName;
        if (tableStats != null) {
            for (Map.Entry<String, Object> entry : tableStats.entrySet()) {
                tableName = entry.getKey();
                sqlTableStat = (WallSqlTableStat)entry.getValue();
                WallTableStat tableStat = this.getTableStat(tableName);
                if (tableStat == null) continue;
                tableStat.addSqlTableStat((WallSqlTableStat)sqlTableStat);
            }
        }
        if (functionStats != null) {
            for (Map.Entry<String, Object> entry : functionStats.entrySet()) {
                tableName = entry.getKey();
                sqlTableStat = (WallSqlFunctionStat)entry.getValue();
                WallFunctionStat functionStat = this.getFunctionStatWithLowerName(tableName);
                if (functionStat == null) continue;
                functionStat.addSqlFunctionStat((WallSqlFunctionStat)sqlTableStat);
            }
        }
    }

    public static boolean ispPrivileged() {
        Boolean value = privileged.get();
        if (value == null) {
            return false;
        }
        return value;
    }

    public static <T> T doPrivileged(PrivilegedAction<T> action) {
        Boolean original = privileged.get();
        privileged.set(Boolean.TRUE);
        try {
            T t = action.run();
            return t;
        }
        finally {
            privileged.set(original);
        }
    }

    public static void setTenantValue(Object value) {
        tenantValueLocal.set(value);
    }

    public static Object getTenantValue() {
        return tenantValueLocal.get();
    }

    public long getWhiteListHitCount() {
        return this.whiteListHitCount.get();
    }

    public long getBlackListHitCount() {
        return this.blackListHitCount.get();
    }

    public long getSyntaxErrorCount() {
        return this.syntaxErrorCount.get();
    }

    public long getCheckCount() {
        return this.checkCount.get();
    }

    public long getViolationCount() {
        return this.violationCount.get();
    }

    public long getHardCheckCount() {
        return this.hardCheckCount.get();
    }

    public long getViolationEffectRowCount() {
        return this.violationEffectRowCount.get();
    }

    public void addViolationEffectRowCount(long rowCount) {
        this.violationEffectRowCount.addAndGet(rowCount);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public WallProviderStatValue getStatValue(boolean reset) {
        WallProviderStatValue statValue = new WallProviderStatValue();
        statValue.setName(this.name);
        statValue.setCheckCount(JdbcSqlStatUtils.get(this.checkCount, reset));
        statValue.setHardCheckCount(JdbcSqlStatUtils.get(this.hardCheckCount, reset));
        statValue.setViolationCount(JdbcSqlStatUtils.get(this.violationCount, reset));
        statValue.setViolationEffectRowCount(JdbcSqlStatUtils.get(this.violationEffectRowCount, reset));
        statValue.setBlackListHitCount(JdbcSqlStatUtils.get(this.blackListHitCount, reset));
        statValue.setWhiteListHitCount(JdbcSqlStatUtils.get(this.whiteListHitCount, reset));
        statValue.setSyntaxErrorCount(JdbcSqlStatUtils.get(this.syntaxErrorCount, reset));
        for (Map.Entry entry : this.tableStats.entrySet()) {
            String tableName = (String)entry.getKey();
            WallTableStat tableStat = (WallTableStat)entry.getValue();
            WallTableStatValue tableStatValue = tableStat.getStatValue(reset);
            if (tableStatValue.getTotalExecuteCount() == 0L) continue;
            tableStatValue.setName(tableName);
            statValue.getTables().add(tableStatValue);
        }
        for (Map.Entry entry : this.functionStats.entrySet()) {
            String functionName = (String)entry.getKey();
            WallFunctionStat functionStat = (WallFunctionStat)entry.getValue();
            WallFunctionStatValue functionStatValue = functionStat.getStatValue(reset);
            if (functionStatValue.getInvokeCount() == 0L) continue;
            functionStatValue.setName(functionName);
            statValue.getFunctions().add(functionStatValue);
        }
        Lock lock = reset ? this.lock.writeLock() : this.lock.readLock();
        lock.lock();
        try {
            WallSqlStatValue sqlStatValue;
            WallSqlStat sqlStat;
            String sql;
            if (this.whiteList != null) {
                for (Map.Entry entry : this.whiteList.entrySet()) {
                    sql = (String)entry.getKey();
                    sqlStat = (WallSqlStat)entry.getValue();
                    sqlStatValue = sqlStat.getStatValue(reset);
                    if (sqlStatValue.getExecuteCount() == 0L) continue;
                    sqlStatValue.setSql(sql);
                    long sqlHash = sqlStat.getSqlHash();
                    if (sqlHash == 0L) {
                        sqlHash = Utils.fnv_64(sql);
                        sqlStat.setSqlHash(sqlHash);
                    }
                    sqlStatValue.setSqlHash(sqlHash);
                    statValue.getWhiteList().add(sqlStatValue);
                }
            }
            if (this.blackMergedList != null) {
                for (Map.Entry entry : this.blackMergedList.entrySet()) {
                    sql = (String)entry.getKey();
                    sqlStat = (WallSqlStat)entry.getValue();
                    sqlStatValue = sqlStat.getStatValue(reset);
                    if (sqlStatValue.getExecuteCount() == 0L) continue;
                    sqlStatValue.setSql(sql);
                    statValue.getBlackList().add(sqlStatValue);
                }
            }
        }
        finally {
            lock.unlock();
        }
        return statValue;
    }

    public Map<String, Object> getStatsMap() {
        return this.getStatValue(false).toMap();
    }

    public boolean isWhiteListEnable() {
        return this.whiteListEnable;
    }

    public void setWhiteListEnable(boolean whiteListEnable) {
        this.whiteListEnable = whiteListEnable;
    }

    public boolean isBlackListEnable() {
        return this.blackListEnable;
    }

    public void setBlackListEnable(boolean blackListEnable) {
        this.blackListEnable = blackListEnable;
    }

    public static class WallCommentHandler
    implements Lexer.CommentHandler {
        public static final WallCommentHandler instance = new WallCommentHandler();

        @Override
        public boolean handle(Token lastToken, String comment) {
            if (lastToken == null) {
                return false;
            }
            switch (lastToken) {
                case SELECT: 
                case INSERT: 
                case DELETE: 
                case UPDATE: 
                case TRUNCATE: 
                case SET: 
                case CREATE: 
                case ALTER: 
                case DROP: 
                case SHOW: 
                case REPLACE: {
                    return true;
                }
            }
            WallContext context = WallContext.current();
            if (context != null) {
                context.incrementCommentCount();
            }
            return false;
        }
    }
}

