/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.druid.sql.dialect.odps.parser;

import com.alibaba.druid.sql.ast.SQLExpr;
import com.alibaba.druid.sql.ast.SQLName;
import com.alibaba.druid.sql.ast.SQLObject;
import com.alibaba.druid.sql.ast.SQLStatement;
import com.alibaba.druid.sql.ast.expr.SQLIdentifierExpr;
import com.alibaba.druid.sql.ast.statement.SQLAssignItem;
import com.alibaba.druid.sql.ast.statement.SQLCreateTableStatement;
import com.alibaba.druid.sql.ast.statement.SQLExprTableSource;
import com.alibaba.druid.sql.ast.statement.SQLObjectType;
import com.alibaba.druid.sql.ast.statement.SQLSelect;
import com.alibaba.druid.sql.ast.statement.SQLSelectStatement;
import com.alibaba.druid.sql.ast.statement.SQLSetStatement;
import com.alibaba.druid.sql.ast.statement.SQLShowTablesStatement;
import com.alibaba.druid.sql.ast.statement.SQLSubqueryTableSource;
import com.alibaba.druid.sql.dialect.odps.ast.OdpsAddStatisticStatement;
import com.alibaba.druid.sql.dialect.odps.ast.OdpsAnalyzeTableStatement;
import com.alibaba.druid.sql.dialect.odps.ast.OdpsGrantStmt;
import com.alibaba.druid.sql.dialect.odps.ast.OdpsInsert;
import com.alibaba.druid.sql.dialect.odps.ast.OdpsInsertStatement;
import com.alibaba.druid.sql.dialect.odps.ast.OdpsListStmt;
import com.alibaba.druid.sql.dialect.odps.ast.OdpsReadStatement;
import com.alibaba.druid.sql.dialect.odps.ast.OdpsRemoveStatisticStatement;
import com.alibaba.druid.sql.dialect.odps.ast.OdpsSetLabelStatement;
import com.alibaba.druid.sql.dialect.odps.ast.OdpsShowGrantsStmt;
import com.alibaba.druid.sql.dialect.odps.ast.OdpsShowPartitionsStmt;
import com.alibaba.druid.sql.dialect.odps.ast.OdpsShowStatisticStmt;
import com.alibaba.druid.sql.dialect.odps.ast.OdpsStatisticClause;
import com.alibaba.druid.sql.dialect.odps.parser.OdpsCreateTableParser;
import com.alibaba.druid.sql.dialect.odps.parser.OdpsExprParser;
import com.alibaba.druid.sql.dialect.odps.parser.OdpsLexer;
import com.alibaba.druid.sql.dialect.odps.parser.OdpsSelectParser;
import com.alibaba.druid.sql.parser.ParserException;
import com.alibaba.druid.sql.parser.SQLCreateTableParser;
import com.alibaba.druid.sql.parser.SQLExprParser;
import com.alibaba.druid.sql.parser.SQLSelectParser;
import com.alibaba.druid.sql.parser.SQLStatementParser;
import com.alibaba.druid.sql.parser.Token;
import java.util.List;

public class OdpsStatementParser
extends SQLStatementParser {
    public OdpsStatementParser(String sql) {
        super(new OdpsLexer(sql, true, true), "odps");
        this.exprParser = new OdpsExprParser(this.lexer);
        this.lexer.nextToken();
    }

    public OdpsStatementParser(SQLExprParser exprParser) {
        super(exprParser);
    }

    @Override
    public SQLSelectStatement parseSelect() {
        return new SQLSelectStatement(new OdpsSelectParser(this.exprParser).select(), "odps");
    }

    @Override
    public SQLCreateTableStatement parseCreateTable() {
        OdpsCreateTableParser parser = new OdpsCreateTableParser(this.exprParser);
        return parser.parseCreateTable();
    }

    @Override
    public SQLCreateTableParser getSQLCreateTableParser() {
        return new OdpsCreateTableParser(this.exprParser);
    }

    @Override
    public boolean parseStatementListDialect(List<SQLStatement> statementList) {
        if (this.lexer.token() == Token.FROM) {
            SQLStatement stmt = this.parseInsert();
            statementList.add(stmt);
            return true;
        }
        if (this.lexer.identifierEquals("ANALYZE")) {
            this.lexer.nextToken();
            this.accept(Token.TABLE);
            OdpsAnalyzeTableStatement stmt = new OdpsAnalyzeTableStatement();
            SQLName table = this.exprParser.name();
            stmt.setTable(table);
            if (this.lexer.token() == Token.PARTITION) {
                this.lexer.nextToken();
                this.accept(Token.LPAREN);
                this.parseAssignItems(stmt.getPartition(), stmt);
                this.accept(Token.RPAREN);
            }
            this.accept(Token.COMPUTE);
            this.acceptIdentifier("STATISTICS");
            statementList.add(stmt);
            return true;
        }
        if (this.lexer.identifierEquals("ADD")) {
            this.lexer.nextToken();
            if (this.lexer.identifierEquals("STATISTIC")) {
                this.lexer.nextToken();
                OdpsAddStatisticStatement stmt = new OdpsAddStatisticStatement();
                stmt.setTable(this.exprParser.name());
                stmt.setStatisticClause(this.parseStaticClause());
                statementList.add(stmt);
                return true;
            }
            throw new ParserException("TODO " + this.lexer.info());
        }
        if (this.lexer.identifierEquals("REMOVE")) {
            this.lexer.nextToken();
            if (this.lexer.identifierEquals("STATISTIC")) {
                this.lexer.nextToken();
                OdpsRemoveStatisticStatement stmt = new OdpsRemoveStatisticStatement();
                stmt.setTable(this.exprParser.name());
                stmt.setStatisticClause(this.parseStaticClause());
                statementList.add(stmt);
                return true;
            }
            throw new ParserException("TODO " + this.lexer.info());
        }
        if (this.lexer.identifierEquals("READ")) {
            OdpsReadStatement stmt = new OdpsReadStatement();
            if (this.lexer.hasComment() && this.lexer.isKeepComments()) {
                stmt.addBeforeComment(this.lexer.readAndResetComments());
            }
            this.lexer.nextToken();
            stmt.setTable(this.exprParser.name());
            if (this.lexer.token() == Token.LPAREN) {
                this.lexer.nextToken();
                this.exprParser.names(stmt.getColumns(), stmt);
                this.accept(Token.RPAREN);
            }
            if (this.lexer.token() == Token.PARTITION) {
                this.lexer.nextToken();
                this.accept(Token.LPAREN);
                this.parseAssignItems(stmt.getPartition(), stmt);
                this.accept(Token.RPAREN);
            }
            if (this.lexer.token() == Token.LITERAL_INT) {
                stmt.setRowCount(this.exprParser.primary());
            }
            statementList.add(stmt);
            return true;
        }
        if (this.lexer.identifierEquals("LIST")) {
            OdpsListStmt stmt = new OdpsListStmt();
            this.lexer.nextToken();
            stmt.setObject(this.exprParser.expr());
            statementList.add(stmt);
            return true;
        }
        if (this.lexer.token() == Token.DESC || this.lexer.identifierEquals("DESCRIBE")) {
            SQLStatement stmt = this.parseDescribe();
            statementList.add(stmt);
            return true;
        }
        return false;
    }

    protected OdpsStatisticClause parseStaticClause() {
        if (this.lexer.identifierEquals("TABLE_COUNT")) {
            this.lexer.nextToken();
            return new OdpsStatisticClause.TableCount();
        }
        if (this.lexer.identifierEquals("NULL_VALUE")) {
            this.lexer.nextToken();
            OdpsStatisticClause.NullValue null_value = new OdpsStatisticClause.NullValue();
            null_value.setColumn(this.exprParser.name());
            return null_value;
        }
        if (this.lexer.identifierEquals("COLUMN_SUM")) {
            this.lexer.nextToken();
            OdpsStatisticClause.ColumnSum column_sum = new OdpsStatisticClause.ColumnSum();
            column_sum.setColumn(this.exprParser.name());
            return column_sum;
        }
        if (this.lexer.identifierEquals("COLUMN_MAX")) {
            this.lexer.nextToken();
            OdpsStatisticClause.ColumnMax column_max = new OdpsStatisticClause.ColumnMax();
            column_max.setColumn(this.exprParser.name());
            return column_max;
        }
        if (this.lexer.identifierEquals("COLUMN_MIN")) {
            this.lexer.nextToken();
            OdpsStatisticClause.ColumnMin column_min = new OdpsStatisticClause.ColumnMin();
            column_min.setColumn(this.exprParser.name());
            return column_min;
        }
        if (this.lexer.identifierEquals("EXPRESSION_CONDITION")) {
            this.lexer.nextToken();
            OdpsStatisticClause.ExpressionCondition expr_condition = new OdpsStatisticClause.ExpressionCondition();
            expr_condition.setExpr(this.exprParser.expr());
            return expr_condition;
        }
        throw new ParserException("TODO " + this.lexer.info());
    }

    @Override
    public SQLStatement parseInsert() {
        OdpsInsertStatement stmt = new OdpsInsertStatement();
        if (this.lexer.token() == Token.FROM) {
            this.lexer.nextToken();
            if (this.lexer.token() == Token.IDENTIFIER) {
                SQLName tableName = this.exprParser.name();
                SQLExprTableSource from = new SQLExprTableSource(tableName);
                stmt.setFrom(from);
            } else {
                this.accept(Token.LPAREN);
                SQLSelectParser selectParser = this.createSQLSelectParser();
                SQLSelect select = selectParser.select();
                this.accept(Token.RPAREN);
                String alias = this.lexer.stringVal();
                this.accept(Token.IDENTIFIER);
                SQLSubqueryTableSource from = new SQLSubqueryTableSource(select, alias);
                stmt.setFrom(from);
            }
        }
        do {
            OdpsInsert insert = this.parseOdpsInsert();
            stmt.addItem(insert);
        } while (this.lexer.token() == Token.INSERT);
        return stmt;
    }

    @Override
    public SQLSelectParser createSQLSelectParser() {
        return new OdpsSelectParser(this.exprParser, this.selectListCache);
    }

    public OdpsInsert parseOdpsInsert() {
        OdpsInsert insert = new OdpsInsert();
        if (this.lexer.isKeepComments() && this.lexer.hasComment()) {
            insert.addBeforeComment(this.lexer.readAndResetComments());
        }
        SQLSelectParser selectParser = this.createSQLSelectParser();
        this.accept(Token.INSERT);
        if (this.lexer.token() == Token.INTO) {
            this.lexer.nextToken();
        } else {
            this.accept(Token.OVERWRITE);
            insert.setOverwrite(true);
        }
        this.accept(Token.TABLE);
        insert.setTableSource(this.exprParser.name());
        if (this.lexer.token() == Token.PARTITION) {
            this.lexer.nextToken();
            this.accept(Token.LPAREN);
            while (true) {
                SQLAssignItem ptExpr = new SQLAssignItem();
                ptExpr.setTarget(this.exprParser.name());
                if (this.lexer.token() == Token.EQ) {
                    this.lexer.nextToken();
                    SQLExpr ptValue = this.exprParser.expr();
                    ptExpr.setValue(ptValue);
                }
                insert.addPartition(ptExpr);
                if (this.lexer.token() != Token.COMMA) break;
                this.lexer.nextToken();
            }
            this.accept(Token.RPAREN);
        }
        SQLSelect query = selectParser.select();
        insert.setQuery(query);
        return insert;
    }

    @Override
    public SQLStatement parseShow() {
        this.accept(Token.SHOW);
        if (this.lexer.identifierEquals("PARTITIONS")) {
            this.lexer.nextToken();
            OdpsShowPartitionsStmt stmt = new OdpsShowPartitionsStmt();
            SQLExpr expr = this.exprParser.expr();
            stmt.setTableSource(new SQLExprTableSource(expr));
            return stmt;
        }
        if (this.lexer.identifierEquals("STATISTIC")) {
            this.lexer.nextToken();
            OdpsShowStatisticStmt stmt = new OdpsShowStatisticStmt();
            SQLExpr expr = this.exprParser.expr();
            stmt.setTableSource(new SQLExprTableSource(expr));
            return stmt;
        }
        if (this.lexer.identifierEquals("TABLES")) {
            this.lexer.nextToken();
            SQLShowTablesStatement stmt = new SQLShowTablesStatement();
            if (this.lexer.token() == Token.FROM) {
                this.lexer.nextToken();
                stmt.setDatabase(this.exprParser.name());
            }
            if (this.lexer.token() == Token.LIKE) {
                this.lexer.nextToken();
                stmt.setLike(this.exprParser.expr());
            }
            return stmt;
        }
        if (this.lexer.identifierEquals("GRANTS")) {
            this.lexer.nextToken();
            OdpsShowGrantsStmt stmt = new OdpsShowGrantsStmt();
            if (this.lexer.token() == Token.FOR) {
                this.lexer.nextToken();
                stmt.setUser(this.exprParser.expr());
            }
            if (this.lexer.token() == Token.ON) {
                this.lexer.nextToken();
                this.acceptIdentifier("type");
                stmt.setObjectType(this.exprParser.expr());
            }
            return stmt;
        }
        throw new ParserException("TODO " + this.lexer.info());
    }

    @Override
    public SQLStatement parseSet() {
        List<String> comments = null;
        if (this.lexer.isKeepComments() && this.lexer.hasComment()) {
            comments = this.lexer.readAndResetComments();
        }
        this.accept(Token.SET);
        if (this.lexer.identifierEquals("LABEL")) {
            OdpsSetLabelStatement stmt = new OdpsSetLabelStatement();
            if (comments != null) {
                stmt.addBeforeComment(comments);
            }
            this.lexer.nextToken();
            stmt.setLabel(this.lexer.stringVal());
            this.lexer.nextToken();
            this.accept(Token.TO);
            if (this.lexer.token() == Token.USER) {
                this.lexer.nextToken();
                SQLName name = this.exprParser.name();
                stmt.setUser(name);
                return stmt;
            }
            this.accept(Token.TABLE);
            SQLName expr = this.exprParser.name();
            stmt.setTable(new SQLExprTableSource(expr));
            if (this.lexer.token() == Token.LPAREN) {
                this.lexer.nextToken();
                this.exprParser.names(stmt.getColumns(), stmt);
                this.accept(Token.RPAREN);
            }
            return stmt;
        }
        SQLSetStatement stmt = new SQLSetStatement(this.getDbType());
        if (comments != null) {
            stmt.addBeforeComment(comments);
        }
        this.parseAssignItems(stmt.getItems(), stmt);
        return stmt;
    }

    @Override
    public OdpsGrantStmt parseGrant() {
        this.accept(Token.GRANT);
        OdpsGrantStmt stmt = new OdpsGrantStmt();
        if (this.lexer.identifierEquals("LABEL")) {
            stmt.setLabel(true);
            this.lexer.nextToken();
            stmt.setLabel(this.exprParser.expr());
        } else {
            if (this.lexer.identifierEquals("SUPER")) {
                stmt.setSuper(true);
                this.lexer.nextToken();
            }
            this.parsePrivileages(stmt.getPrivileges(), stmt);
        }
        if (this.lexer.token() == Token.ON) {
            this.lexer.nextToken();
            if (this.lexer.identifierEquals("PROJECT")) {
                this.lexer.nextToken();
                stmt.setObjectType(SQLObjectType.PROJECT);
            } else if (this.lexer.identifierEquals("PACKAGE")) {
                this.lexer.nextToken();
                stmt.setObjectType(SQLObjectType.PACKAGE);
            } else if (this.lexer.token() == Token.FUNCTION) {
                this.lexer.nextToken();
                stmt.setObjectType(SQLObjectType.FUNCTION);
            } else if (this.lexer.token() == Token.TABLE) {
                this.lexer.nextToken();
                stmt.setObjectType(SQLObjectType.TABLE);
                if (this.lexer.token() == Token.LPAREN) {
                    this.lexer.nextToken();
                    this.exprParser.names(stmt.getColumns(), stmt);
                    this.accept(Token.RPAREN);
                }
            } else if (this.lexer.identifierEquals("RESOURCE")) {
                this.lexer.nextToken();
                stmt.setObjectType(SQLObjectType.RESOURCE);
            } else if (this.lexer.identifierEquals("INSTANCE")) {
                this.lexer.nextToken();
                stmt.setObjectType(SQLObjectType.INSTANCE);
            } else if (this.lexer.identifierEquals("JOB")) {
                this.lexer.nextToken();
                stmt.setObjectType(SQLObjectType.JOB);
            } else if (this.lexer.identifierEquals("VOLUME")) {
                this.lexer.nextToken();
                stmt.setObjectType(SQLObjectType.VOLUME);
            } else if (this.lexer.identifierEquals("OfflineModel")) {
                this.lexer.nextToken();
                stmt.setObjectType(SQLObjectType.OfflineModel);
            } else if (this.lexer.identifierEquals("XFLOW")) {
                this.lexer.nextToken();
                stmt.setObjectType(SQLObjectType.XFLOW);
            }
            stmt.setOn(this.exprParser.expr());
        }
        if (this.lexer.token() == Token.TO) {
            this.lexer.nextToken();
            if (this.lexer.token() == Token.USER) {
                this.lexer.nextToken();
                stmt.setSubjectType(SQLObjectType.USER);
            } else if (this.lexer.identifierEquals("ROLE")) {
                this.lexer.nextToken();
                stmt.setSubjectType(SQLObjectType.ROLE);
            }
            stmt.setTo(this.exprParser.expr());
        }
        if (this.lexer.token() == Token.WITH) {
            this.lexer.nextToken();
            this.acceptIdentifier("EXP");
            stmt.setExpire(this.exprParser.expr());
        }
        return stmt;
    }

    @Override
    protected void parsePrivileages(List<SQLExpr> privileges, SQLObject parent) {
        while (true) {
            String privilege = null;
            if (this.lexer.token() == Token.ALL) {
                this.lexer.nextToken();
                privilege = "ALL";
            } else if (this.lexer.token() == Token.SELECT) {
                privilege = "SELECT";
                this.lexer.nextToken();
            } else if (this.lexer.token() == Token.UPDATE) {
                privilege = "UPDATE";
                this.lexer.nextToken();
            } else if (this.lexer.token() == Token.DELETE) {
                privilege = "DELETE";
                this.lexer.nextToken();
            } else if (this.lexer.token() == Token.INSERT) {
                privilege = "INSERT";
                this.lexer.nextToken();
            } else if (this.lexer.token() == Token.DROP) {
                this.lexer.nextToken();
                privilege = "DROP";
            } else if (this.lexer.token() == Token.ALTER) {
                this.lexer.nextToken();
                privilege = "ALTER";
            } else if (this.lexer.identifierEquals("DESCRIBE")) {
                privilege = "DESCRIBE";
                this.lexer.nextToken();
            } else if (this.lexer.identifierEquals("READ")) {
                privilege = "READ";
                this.lexer.nextToken();
            } else if (this.lexer.identifierEquals("WRITE")) {
                privilege = "WRITE";
                this.lexer.nextToken();
            } else if (this.lexer.identifierEquals("EXECUTE")) {
                this.lexer.nextToken();
                privilege = "EXECUTE";
            } else if (this.lexer.identifierEquals("LIST")) {
                this.lexer.nextToken();
                privilege = "LIST";
            } else if (this.lexer.identifierEquals("CreateTable")) {
                this.lexer.nextToken();
                privilege = "CreateTable";
            } else if (this.lexer.identifierEquals("CreateInstance")) {
                this.lexer.nextToken();
                privilege = "CreateInstance";
            } else if (this.lexer.identifierEquals("CreateFunction")) {
                this.lexer.nextToken();
                privilege = "CreateFunction";
            } else if (this.lexer.identifierEquals("CreateResource")) {
                this.lexer.nextToken();
                privilege = "CreateResource";
            } else if (this.lexer.identifierEquals("CreateJob")) {
                this.lexer.nextToken();
                privilege = "CreateJob";
            } else if (this.lexer.identifierEquals("CreateVolume")) {
                this.lexer.nextToken();
                privilege = "CreateVolume";
            } else if (this.lexer.identifierEquals("CreateOfflineModel")) {
                this.lexer.nextToken();
                privilege = "CreateOfflineModel";
            } else if (this.lexer.identifierEquals("CreateXflow")) {
                this.lexer.nextToken();
                privilege = "CreateXflow";
            }
            SQLExpr expr = null;
            expr = privilege != null ? new SQLIdentifierExpr(privilege) : this.exprParser.expr();
            expr.setParent(parent);
            privileges.add(expr);
            if (this.lexer.token() != Token.COMMA) break;
            this.lexer.nextToken();
        }
    }
}

